clear;clc
folder = 'D:\project\IGEM\rgb2';
R_values=[];G_values=[];B_values=[];RG_values=[];RB_values=[];GB_values=[];
image_files = dir(fullfile(folder, '*.png')); % 读取文件夹中所有 .jpg 文件
for i=1:6
    file_name = image_files(i).name;
    file_path = fullfile(folder, file_name);
    img = imread(file_path); % 读取图片
    %hsv_img = rgb2hsv(img);
    %hsv_img(:,:,3)=120;
    %img = hsv2rgb(hsv_img);
    %imshow(img); % 显示图片
    %h = drawrectangle(); % 手动绘制矩形
    %position = h.Position; % 获取矩形的坐标
    %cropped_img = imcrop(img, position); % 裁剪图片
   %imshow(cropped_img); % 显示图片
% 计算裁剪区域的 RGB 平均值
R_mean= mean(mean(img(:,:,1)));
G_mean= mean(mean(img(:,:,2)));
B_mean= mean(mean(img(:,:,3)));
RG_mean=R_mean/G_mean;
RB_mean=R_mean/B_mean;
GB_mean=G_mean/B_mean;

R_values = [R_values,R_mean];
G_values = [G_values,G_mean];
B_values = [B_values,B_mean];
RG_values =[RG_values,RG_mean];
RB_values =[GB_values,RB_mean];
GB_values =[GB_values,GB_mean];

end

concentration = [0,2,4,6,8,10]; % 不同图片的浓度

X = [R_values', G_values', B_values', ones(length(R_values), 1)]; % 最后一列为常数1，用于计算截距 D
coefficients = regress(concentration', X);
X_coef = coefficients(1); % 对应R通道的系数
Y_coef = coefficients(2); % 对应G通道的系数
Z_coef = coefficients(3); % 对应B通道的系数
D_coef = coefficients(4); % 截距

% 假设新的图片的 RGB 值
R_new = 120;
G_new = 130;
B_new = 140;

% 使用拟合模型预测浓度
predicted_concentration = X_coef * R_new + Y_coef * G_new + Z_coef * B_new + D_coef;
disp(['Predicted concentration: ', num2str(predicted_concentration)]);

% 计算拟合的浓度值
fitted_concentration = X * coefficients;

% 绘制实际浓度与拟合浓度对比图
figure;
plot(concentration, fitted_concentration, 'o');
hold on;
plot(concentration, concentration, '-');
xlabel('Actual Concentration');
ylabel('Fitted Concentration');
title('Fitted vs Actual Concentration');
legend('Fitted Data', 'Ideal Line');

%计算相关系数
% 计算残差平方和 (SS_res)
SS_res = sum((concentration' - fitted_concentration).^2);

% 计算总平方和 (SS_tot)
SS_tot = sum((concentration' - mean(concentration)).^2);

% 计算 R^2 值
R_squared = 1 - (SS_res / SS_tot);

% 输出 R^2 值
disp(['R-squared: ', num2str(R_squared)]);
